/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.digitalekabeltelevisie.gui.ImageSource;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class ImageSaveAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ImageSaveAction.class.getName());
    private final JPanel panel;
    private final ImageSource imageSource;

    public ImageSaveAction(JPanel panel, String name, ImageSource imageSource) {
        super(name);
        this.panel = panel;
        this.imageSource = imageSource;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BufferedImage image = this.imageSource.getImage();
        if (image != null) {
            JFileChooser chooser = GuiUtils.createFileChooser(List.of(new FileNameExtensionFilter("JPG", "jpg", "jpeg"), new FileNameExtensionFilter("PNG", "png")));
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            File saveFile = new File("dvb_inspector_image_" + df.format(new Date()));
            chooser.setSelectedFile(saveFile);
            int rval = chooser.showSaveDialog(this.panel);
            if (rval == 0) {
                int n;
                saveFile = chooser.getSelectedFile();
                PreferencesManager.setSaveDir(saveFile.getParent());
                FileNameExtensionFilter filter = (FileNameExtensionFilter)chooser.getFileFilter();
                String extension = filter.getExtensions()[0];
                if (!saveFile.getName().endsWith("." + extension)) {
                    saveFile = new File(saveFile.getPath() + "." + extension);
                }
                boolean write = true;
                if (saveFile.exists() && (n = JOptionPane.showConfirmDialog(this.panel, "File " + String.valueOf(saveFile) + " already exists, want to overwrite?", "File already exists", 0)) == 1) {
                    write = false;
                }
                if (write) {
                    try {
                        ImageIO.write((RenderedImage)image, extension, saveFile);
                    }
                    catch (IOException ex) {
                        logger.warning(() -> "IOException while saving image; " + String.valueOf(ex));
                    }
                }
            }
        }
    }
}

