/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.gui.PacketSelectionPanel;
import nl.digitalekabeltelevisie.main.DVBinspector;

public class PIDDialog
extends JDialog
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = -3439016568120119881L;
    private final JList<ChartLabel> leftList;
    private final JList<ChartLabel> rightList;
    private DefaultListModel<ChartLabel> leftListModel;
    private DefaultListModel<ChartLabel> rightListModel;
    private final DVBinspector controller;
    private final AddAllAction addAllAction;
    private final AddAction addAction;
    private final SwitchAction switchAction;
    private final RemoveAction removeAction;
    private final RemoveAllAction removeAllAction;
    private final TopAction topAction;
    private final UpAction upAction;
    private final ReverseAction reverseAction;
    private final DownAction downAction;
    private final BottomAction bottomAction;
    private ViewContext orgView;
    private final PacketSelectionPanel packetSelectionStart;
    private final PacketSelectionPanel packetSelectionEnd;
    private final JComboBox<Integer> stepsChooser;
    public static final Integer[] STEP_OPTIONS = new Integer[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000};

    public void enableButtons() {
        boolean leftEmpty = this.leftListModel.isEmpty();
        boolean rightEmpty = this.rightListModel.isEmpty();
        int rightNumbers = this.rightListModel.getSize();
        this.addAllAction.setEnabled(!leftEmpty);
        this.addAction.setEnabled(!leftEmpty && this.leftList.getSelectedIndex() != -1);
        this.switchAction.setEnabled(true);
        this.removeAction.setEnabled(!rightEmpty && this.rightList.getSelectedIndex() != -1);
        this.removeAllAction.setEnabled(!rightEmpty);
        this.topAction.setEnabled(!rightEmpty && this.rightList.getSelectedIndex() > 0);
        this.upAction.setEnabled(!rightEmpty && this.rightList.getSelectedIndex() > 0);
        this.reverseAction.setEnabled(!rightEmpty);
        this.downAction.setEnabled(!rightEmpty && this.rightList.getSelectedIndex() < rightNumbers - 1 && this.rightList.getSelectedIndex() != -1);
        this.bottomAction.setEnabled(!rightEmpty && this.rightList.getSelectedIndex() < rightNumbers - 1 && this.rightList.getSelectedIndex() != -1);
    }

    public PIDDialog(Frame aFrame, ViewContext viewContext, DVBinspector binspector) {
        super(aFrame, true);
        this.controller = binspector;
        this.setTitle("PID Selector");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel pidPanel = new JPanel();
        pidPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("PID Filter"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel packetPanel = new JPanel();
        pidPanel.setLayout(new BoxLayout(pidPanel, 0));
        this.leftListModel = new DefaultListModel();
        for (ChartLabel label : viewContext.getNotShown()) {
            this.leftListModel.addElement(label);
        }
        this.leftList = new JList<ChartLabel>(this.leftListModel);
        this.leftList.setSelectionMode(0);
        this.rightListModel = new DefaultListModel();
        for (ChartLabel label : viewContext.getShown()) {
            this.rightListModel.addElement(label);
        }
        this.rightList = new JList<ChartLabel>(this.rightListModel);
        this.rightList.setSelectionMode(0);
        JPanel buttonPanel = new JPanel();
        JPanel sortButtonPanel = new JPanel();
        JPanel okCancelPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.setLayout(new FlowLayout());
        this.addAllAction = new AddAllAction("add all >>");
        JButton addAllButton = new JButton(this.addAllAction);
        addAllButton.setAlignmentX(0.5f);
        buttonPanel.add(addAllButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.addAction = new AddAction("add >");
        JButton addButton = new JButton(this.addAction);
        addButton.setAlignmentX(0.5f);
        buttonPanel.add(addButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.switchAction = new SwitchAction("< swap >");
        JButton switchButton = new JButton(this.switchAction);
        switchButton.setAlignmentX(0.5f);
        buttonPanel.add(switchButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.removeAction = new RemoveAction("< remove");
        JButton removeButton = new JButton(this.removeAction);
        removeButton.setAlignmentX(0.5f);
        buttonPanel.add(removeButton);
        buttonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.removeAllAction = new RemoveAllAction("<< remove all");
        JButton removeAllButton = new JButton(this.removeAllAction);
        removeAllButton.setAlignmentX(0.5f);
        buttonPanel.add(removeAllButton);
        this.leftList.addListSelectionListener(this);
        this.rightList.addListSelectionListener(this);
        this.topAction = new TopAction("Top");
        JButton topButton = new JButton(this.topAction);
        topButton.setAlignmentX(0.5f);
        this.upAction = new UpAction("Up");
        JButton upButton = new JButton(this.upAction);
        upButton.setAlignmentX(0.5f);
        this.reverseAction = new ReverseAction("Reverse");
        JButton reverseButton = new JButton(this.reverseAction);
        reverseButton.setAlignmentX(0.5f);
        this.downAction = new DownAction("Down");
        JButton downButton = new JButton(this.downAction);
        downButton.setAlignmentX(0.5f);
        this.bottomAction = new BottomAction("Bottom");
        JButton bottomButton = new JButton(this.bottomAction);
        bottomButton.setAlignmentX(0.5f);
        sortButtonPanel.setLayout(new BoxLayout(sortButtonPanel, 1));
        sortButtonPanel.add(topButton);
        sortButtonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        sortButtonPanel.add(upButton);
        sortButtonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        sortButtonPanel.add(reverseButton);
        sortButtonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        sortButtonPanel.add(downButton);
        sortButtonPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        sortButtonPanel.add(bottomButton);
        OKAction okAction = new OKAction("OK");
        JButton okButton = new JButton(okAction);
        okButton.setAlignmentX(0.5f);
        ApplyAction applyAction = new ApplyAction("Apply");
        JButton applyButton = new JButton(applyAction);
        applyButton.setAlignmentX(0.5f);
        CancelAction cancelAction = new CancelAction("Cancel");
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setAlignmentX(0.5f);
        okCancelPanel.add(okButton);
        okCancelPanel.add(applyButton);
        okCancelPanel.add(cancelButton);
        JScrollPane leftListScroller = new JScrollPane(this.leftList);
        int h = (int)Math.max(this.leftList.getPreferredSize().getHeight(), this.rightList.getPreferredSize().getHeight());
        int w = (int)Math.max(this.leftList.getPreferredSize().getWidth(), this.rightList.getPreferredSize().getWidth());
        leftListScroller.setSize(new Dimension(w, h));
        JScrollPane rightlistScroller = new JScrollPane(this.rightList);
        rightlistScroller.setSize(new Dimension(w, h));
        pidPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        pidPanel.add(leftListScroller);
        pidPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        pidPanel.add(buttonPanel);
        pidPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        pidPanel.add(rightlistScroller);
        pidPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        pidPanel.add(sortButtonPanel);
        pidPanel.add(Box.createRigidArea(new Dimension(10, 10)));
        this.packetSelectionStart = new PacketSelectionPanel("Start packet", 0, viewContext.getMaxPacket(), 0);
        this.packetSelectionEnd = new PacketSelectionPanel("End packet", 0, viewContext.getMaxPacket(), viewContext.getMaxPacket());
        packetPanel.setLayout(new BoxLayout(packetPanel, 1));
        packetPanel.add(this.packetSelectionStart);
        packetPanel.add(this.packetSelectionEnd);
        JPanel stepsChooserPanel = new JPanel();
        stepsChooserPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Steps"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.stepsChooser = new JComboBox<Integer>(STEP_OPTIONS);
        this.stepsChooser.addActionListener(this);
        stepsChooserPanel.add(this.stepsChooser);
        JPanel stepsPanel = new JPanel();
        stepsPanel.setLayout(new BoxLayout(stepsPanel, 0));
        stepsPanel.add(packetPanel);
        stepsPanel.add(stepsChooserPanel);
        panel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        panel.add((Component)stepsPanel, "North");
        panel.add((Component)pidPanel, "Center");
        panel.add((Component)okCancelPanel, "South");
        this.setContentPane(panel);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PIDDialog.this.resetLists();
            }
        });
        panel.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.enableButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableButtons();
    }

    public void setConfig(ViewContext viewContext) {
        this.orgView = viewContext;
        this.resetLists(viewContext);
    }

    public void resetLists(ViewContext viewContex) {
        this.leftListModel.clear();
        for (ChartLabel label : viewContex.getNotShown()) {
            this.leftListModel.addElement(label);
        }
        this.rightListModel.clear();
        for (ChartLabel label : viewContex.getShown()) {
            this.rightListModel.addElement(label);
        }
        this.packetSelectionStart.setRangeValue(0, viewContex.getMaxPacket() - 1, viewContex.getStartPacket());
        this.packetSelectionEnd.setRangeValue(1, viewContex.getMaxPacket(), viewContex.getEndPacket());
        for (int i = 0; i < this.stepsChooser.getItemCount(); ++i) {
            if (viewContex.getGraphSteps() != this.stepsChooser.getItemAt(i).intValue()) continue;
            this.stepsChooser.setSelectedIndex(i);
        }
        this.pack();
        this.rightList.revalidate();
        this.leftList.revalidate();
        this.pack();
    }

    public void resetLists() {
        this.resetLists(this.orgView);
    }

    public void clearAndHide() {
        this.resetLists();
        this.setVisible(false);
    }

    class AddAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 3689777563900027556L;

        public AddAllAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<ChartLabel> el = PIDDialog.this.leftListModel.elements();
            while (el.hasMoreElements()) {
                PIDDialog.this.rightListModel.addElement(el.nextElement());
            }
            PIDDialog.this.leftListModel.clear();
            PIDDialog.this.enableButtons();
        }
    }

    class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 8979337275391648459L;

        public AddAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.leftList.getSelectedIndex();
            if (index != -1) {
                int rightIndex = PIDDialog.this.rightList.getSelectedIndex();
                if (rightIndex == -1) {
                    rightIndex = PIDDialog.this.rightListModel.getSize();
                }
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.leftListModel.elementAt(index), rightIndex);
                PIDDialog.this.leftListModel.remove(index);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class SwitchAction
    extends AbstractAction {
        private static final long serialVersionUID = 2303116336558669473L;

        public SwitchAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel<ChartLabel> tmp = PIDDialog.this.leftListModel;
            PIDDialog.this.leftListModel = PIDDialog.this.rightListModel;
            PIDDialog.this.leftList.setModel(PIDDialog.this.rightListModel);
            PIDDialog.this.rightListModel = tmp;
            PIDDialog.this.rightList.setModel(PIDDialog.this.rightListModel);
            PIDDialog.this.enableButtons();
        }
    }

    class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 2805825694107261544L;

        public RemoveAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            if (index != -1) {
                int leftIndex = PIDDialog.this.leftList.getSelectedIndex();
                if (leftIndex == -1) {
                    leftIndex = PIDDialog.this.leftListModel.getSize();
                }
                PIDDialog.this.leftListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(index), leftIndex);
                PIDDialog.this.rightListModel.remove(index);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class RemoveAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 4811839547583190284L;

        public RemoveAllAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Enumeration<ChartLabel> el = PIDDialog.this.rightListModel.elements();
            while (el.hasMoreElements()) {
                PIDDialog.this.leftListModel.addElement(el.nextElement());
            }
            PIDDialog.this.rightListModel.clear();
            PIDDialog.this.enableButtons();
        }
    }

    class TopAction
    extends AbstractAction {
        private static final long serialVersionUID = 3209628912633150373L;

        public TopAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            if (index != -1) {
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(index), 0);
                PIDDialog.this.rightListModel.remove(index + 1);
                PIDDialog.this.rightList.setSelectedIndex(0);
                PIDDialog.this.rightList.ensureIndexIsVisible(0);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class UpAction
    extends AbstractAction {
        private static final long serialVersionUID = 3534182235010446238L;

        public UpAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            if (index != -1) {
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(index), index - 1);
                PIDDialog.this.rightListModel.remove(index + 1);
                PIDDialog.this.rightList.setSelectedIndex(index - 1);
                PIDDialog.this.rightList.ensureIndexIsVisible(index - 1);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class ReverseAction
    extends AbstractAction {
        private static final long serialVersionUID = -4739983729332909990L;

        public ReverseAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            int l = PIDDialog.this.rightListModel.size();
            for (int i = 0; i < l / 2; ++i) {
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(l - i - 1), i);
                PIDDialog.this.rightListModel.remove(l - i);
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(i + 1), l - i);
                PIDDialog.this.rightListModel.remove(i + 1);
            }
            if (index != -1) {
                PIDDialog.this.rightList.setSelectedIndex(l - 1 - index);
                PIDDialog.this.rightList.ensureIndexIsVisible(l - 1 - index);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class DownAction
    extends AbstractAction {
        private static final long serialVersionUID = -7274215756253610038L;

        public DownAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            if (index != -1) {
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(index), index + 2);
                PIDDialog.this.rightListModel.remove(index);
                PIDDialog.this.rightList.setSelectedIndex(index + 1);
                PIDDialog.this.rightList.ensureIndexIsVisible(index + 1);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class BottomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1894143066033119542L;

        public BottomAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PIDDialog.this.rightList.getSelectedIndex();
            if (index != -1) {
                int s = PIDDialog.this.rightListModel.getSize();
                PIDDialog.this.rightListModel.insertElementAt(PIDDialog.this.rightListModel.elementAt(index), s);
                PIDDialog.this.rightListModel.remove(index);
                PIDDialog.this.rightList.setSelectedIndex(s - 1);
                PIDDialog.this.rightList.ensureIndexIsVisible(s - 1);
            }
            PIDDialog.this.enableButtons();
        }
    }

    class OKAction
    extends ApplyAction {
        private static final long serialVersionUID = -4143479183600719898L;

        public OKAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            PIDDialog.this.setVisible(false);
        }
    }

    class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = 8414410738504899008L;

        public ApplyAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArrayList<ChartLabel> shown = new ArrayList<ChartLabel>();
            Enumeration<ChartLabel> el = PIDDialog.this.rightListModel.elements();
            while (el.hasMoreElements()) {
                shown.add(el.nextElement());
            }
            ArrayList<ChartLabel> notShown = new ArrayList<ChartLabel>();
            Enumeration<ChartLabel> el2 = PIDDialog.this.leftListModel.elements();
            while (el2.hasMoreElements()) {
                notShown.add(el2.nextElement());
            }
            PIDDialog.this.orgView.setShown(shown);
            PIDDialog.this.orgView.setNotShown(notShown);
            PIDDialog.this.orgView.setStartPacket(PIDDialog.this.packetSelectionStart.getValue());
            PIDDialog.this.orgView.setEndPacket(PIDDialog.this.packetSelectionEnd.getValue());
            PIDDialog.this.orgView.setGraphSteps((Integer)PIDDialog.this.stepsChooser.getSelectedItem());
            PIDDialog.this.controller.setPIDList(PIDDialog.this.orgView);
        }
    }

    class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = -6217921517985338175L;

        public CancelAction(String text) {
            super(text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PIDDialog.this.clearAndHide();
        }
    }
}

