/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import com.opencsv.CSVWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;
import nl.digitalekabeltelevisie.gui.TableColumnAdjuster;
import nl.digitalekabeltelevisie.gui.TableCopyAction;
import nl.digitalekabeltelevisie.gui.TableSaveAction;
import nl.digitalekabeltelevisie.gui.utils.WrapLayout;
import nl.digitalekabeltelevisie.util.tablemodel.cellrenderer.StreamTypeTableCellRenderer;

public class TablePanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(TablePanel.class.getName());
    private final JTable table;
    private final TableColumnAdjuster tca;
    private final JScrollPane tableScrollPane;
    private final JCheckBox includeHeadersCheckBox;

    public TablePanel(final JTable table) {
        super(new BorderLayout());
        this.setFocusable(true);
        this.tableScrollPane = new JScrollPane(table);
        MouseAdapter mouseAdapter = new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                table.requestFocusInWindow();
            }
        };
        this.tableScrollPane.addMouseListener(mouseAdapter);
        this.table = table;
        table.setFocusable(true);
        JPanel buttonToolbar = new JPanel(new WrapLayout(0));
        buttonToolbar.addMouseListener(mouseAdapter);
        TableCopyAction copyAction = new TableCopyAction(this, "Copy");
        JButton copyButton = new JButton(copyAction);
        KeyStroke copyKey = KeyStroke.getKeyStroke(67, 128);
        this.getInputMap().put(copyKey, "copy");
        this.getActionMap().put("copy", copyAction);
        table.getActionMap().put("copy", copyAction);
        buttonToolbar.getActionMap().put("copy", copyAction);
        buttonToolbar.add(copyButton);
        TableSaveAction saveAction = new TableSaveAction(this, "Save As...");
        JButton saveButton = new JButton(saveAction);
        KeyStroke saveKey = KeyStroke.getKeyStroke(83, 128);
        table.getInputMap().put(saveKey, "save");
        table.getActionMap().put("save", saveAction);
        buttonToolbar.add(saveButton);
        buttonToolbar.add(Box.createHorizontalStrut(10));
        this.includeHeadersCheckBox = new JCheckBox("Include Headers in Copy/Save");
        buttonToolbar.add(this.includeHeadersCheckBox);
        table.setAutoCreateRowSorter(true);
        table.setAutoResizeMode(0);
        table.setDefaultRenderer(StreamTypeTableCellRenderer.class, new StreamTypeTableCellRenderer());
        this.tca = new TableColumnAdjuster(table);
        this.tca.adjustColumns();
        this.add((Component)buttonToolbar, "First");
        this.add((Component)this.tableScrollPane, "Center");
    }

    public void setModel(TableModel tableModel) {
        this.table.setModel(tableModel);
        this.tca.adjustColumns();
        this.table.getRowSorter().toggleSortOrder(0);
        this.tableScrollPane.getVerticalScrollBar().setValue(0);
    }

    public String getTableAsHtml() {
        int[] rows = this.getSelectedRows();
        int columnCount = this.table.getColumnCount();
        StringBuilder htmlStr = new StringBuilder();
        htmlStr.append("<html>\n<body>\n<table>\n");
        if (this.includeHeadersCheckBox.isSelected()) {
            htmlStr.append("<tr>\n");
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                String colName = this.table.getColumnName(columnIndex);
                htmlStr.append("  <th>").append(colName).append("</th>\n");
            }
            htmlStr.append("</tr>\n");
        }
        for (int row : rows) {
            htmlStr.append("<tr>\n");
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                htmlStr.append("  <td>").append(Objects.toString(this.table.getValueAt(row, columnIndex), "")).append("</td>\n");
            }
            htmlStr.append("</tr>\n");
        }
        htmlStr.append("</table>\n</body>\n</html>");
        return htmlStr.toString();
    }

    public String getTableAsText() {
        int[] rows = this.getSelectedRows();
        int columnCount = this.table.getColumnCount();
        StringBuilder plainStr = new StringBuilder();
        if (this.includeHeadersCheckBox.isSelected()) {
            for (int col = 0; col < columnCount; ++col) {
                String colName = this.table.getColumnName(col);
                plainStr.append(colName).append('\t');
            }
            plainStr.deleteCharAt(plainStr.length() - 1).append('\n');
        }
        for (int row : rows) {
            for (int columnIndex = 0; columnIndex < columnCount; ++columnIndex) {
                plainStr.append(Objects.toString(this.table.getValueAt(row, columnIndex), "")).append('\t');
            }
            plainStr.deleteCharAt(plainStr.length() - 1).append('\n');
        }
        plainStr.deleteCharAt(plainStr.length() - 1);
        return plainStr.toString();
    }

    public String getTableAsCsv() {
        int[] rows = this.getSelectedRows();
        String res = "";
        try (StringWriter sw = new StringWriter();
             CSVWriter csvWriter = new CSVWriter((Writer)sw);){
            if (this.includeHeadersCheckBox.isSelected()) {
                csvWriter.writeNext(this.getHeaders());
            }
            for (int row : rows) {
                csvWriter.writeNext(this.getRow(row));
            }
            res = sw.toString();
        }
        catch (IOException e) {
            logger.log(Level.INFO, "error building csv content", e);
        }
        return res;
    }

    private String[] getRow(int row) {
        int columnCount = this.table.getColumnCount();
        String[] res = new String[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            res[col] = Objects.toString(this.table.getValueAt(row, col), "");
        }
        return res;
    }

    private String[] getHeaders() {
        int columnCount = this.table.getColumnCount();
        String[] res = new String[columnCount];
        for (int col = 0; col < columnCount; ++col) {
            res[col] = this.table.getColumnName(col);
        }
        return res;
    }

    private int[] getSelectedRows() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            int rowCount = this.table.getRowCount();
            rows = new int[rowCount];
            for (int counter = 0; counter < rowCount; ++counter) {
                rows[counter] = counter;
            }
        }
        return rows;
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getTableScrollPane() {
        return this.tableScrollPane;
    }
}

