/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTs;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.gui.TextHTMLTransferable;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.utils.DVBInspectorDefaultDrawingSupplier;
import nl.digitalekabeltelevisie.gui.utils.GuiUtils;
import nl.digitalekabeltelevisie.gui.utils.TEMIMediaTimeStampNumberFormat;
import nl.digitalekabeltelevisie.gui.utils.TEMIToolTipGenerator;
import nl.digitalekabeltelevisie.gui.utils.TEMIXYDataset;
import nl.digitalekabeltelevisie.gui.utils.TimeStampNumberFormat;
import nl.digitalekabeltelevisie.gui.utils.TimestampXYDataset;
import nl.digitalekabeltelevisie.gui.utils.WrapLayout;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class TimeStampChart
extends JPanel
implements TransportStreamView,
ActionListener {
    private JFreeChart freeChart;
    private final PacketTimeNumberFormat packetTimeNumberFormat = new PacketTimeNumberFormat();
    private final PacketTimeNumberFormatLabel packetTimeNumberFormatLabel = new PacketTimeNumberFormatLabel();
    private boolean usepacketTime = true;
    private final TimeStampNumberFormat timeStampNumberFormat = new TimeStampNumberFormat();
    private final TEMIMediaTimeStampNumberFormat temiNumberFormat = new TEMIMediaTimeStampNumberFormat();
    private TransportStream transportStream;
    private final List<PMTsection> pmts = new ArrayList<PMTsection>();
    private final ChartPanel chartPanel;
    private boolean legendVisible = true;
    private final JComboBox<String> serviceChooser = new JComboBox();
    private ViewContext viewContext;
    private final JPanel seriesSelectionPanel;
    private final JPanel temiSelectionPanel;
    private JRadioButton timeButton;
    private JRadioButton packetNoButton;

    public TimeStampChart(TransportStream transportStream, ViewContext viewContext) {
        super(new BorderLayout());
        this.transportStream = transportStream;
        JPanel topRowbuttonPanel = this.createTopRowButtonPanel();
        this.seriesSelectionPanel = new JPanel(new WrapLayout());
        this.temiSelectionPanel = new JPanel(new WrapLayout());
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        controls.add(topRowbuttonPanel);
        controls.add(this.seriesSelectionPanel);
        controls.add(this.temiSelectionPanel);
        this.add((Component)controls, "First");
        this.chartPanel = new ChartPanel(null, false);
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeStampChart.this.requestFocus();
            }
        });
        InputMap im = this.getInputMap();
        im.put(KeyStroke.getKeyStroke(67, 128), "copytip");
        HoverCopyAction hoverCopyAction = new HoverCopyAction();
        this.getActionMap().put("copytip", hoverCopyAction);
        this.setTransportStream(transportStream, viewContext);
        this.add((Component)this.chartPanel, "Center");
    }

    private JPanel createTopRowButtonPanel() {
        JPanel buttonPanel = new JPanel(new WrapLayout());
        this.addServicesSelect(buttonPanel);
        buttonPanel.add(Box.createHorizontalStrut(20));
        this.addLegendRadioButtons(buttonPanel);
        buttonPanel.add(Box.createHorizontalStrut(20));
        this.addTimePacketNoRadioButtons(buttonPanel);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.invalidate();
        return buttonPanel;
    }

    private void addServicesSelect(JPanel buttonPanel) {
        JLabel typeLabel = new JLabel("Service:");
        buttonPanel.add(typeLabel);
        this.serviceChooser.addActionListener(this);
        buttonPanel.add(this.serviceChooser);
    }

    @Override
    public final void setTransportStream(TransportStream transportStream, ViewContext viewContext) {
        this.transportStream = transportStream;
        this.viewContext = viewContext;
        this.serviceChooser.removeActionListener(this);
        this.serviceChooser.removeAllItems();
        this.pmts.clear();
        if (transportStream == null) {
            this.freeChart = null;
            this.chartPanel.setChart(GuiUtils.createTitleOnlyChart("No transportstream loaded, drag a MPEG-TS (*.ts;*.mpg;*.mpeg;*.m2ts;*.mts;*.tsa;*.tsv) file here"));
            this.seriesSelectionPanel.removeAll();
            this.temiSelectionPanel.removeAll();
        } else if (!PreferencesManager.isEnablePcrPtsView()) {
            this.freeChart = null;
            this.chartPanel.setChart(GuiUtils.createTitleOnlyChart("PCR/PTS/DTS View not enabled, select 'Settings -> Enable PCR/PTS/DTS View' to enable "));
        } else {
            PMTs streamPmts;
            this.timeButton.setEnabled(!transportStream.isAVCHD());
            this.packetNoButton.setEnabled(!transportStream.isAVCHD());
            if (transportStream.isAVCHD()) {
                this.usepacketTime = true;
            }
            if ((streamPmts = transportStream.getPsi().getPmts()).getPmts().isEmpty()) {
                this.chartPanel.setChart(GuiUtils.createTitleOnlyChart("No PMTs found, nothing to display in this graph"));
            } else {
                for (PMTsection[] pmTsections : streamPmts) {
                    PMTsection section = pmTsections[0];
                    if (section.getPcrPid() == 8191) continue;
                    this.pmts.add(section);
                    String name = TimeStampChart.getServiceName(transportStream, section.getProgramNumber());
                    this.serviceChooser.addItem(name + ", PCR_PID : " + section.getPcrPid());
                }
                if (this.pmts.isEmpty()) {
                    this.chartPanel.setChart(GuiUtils.createTitleOnlyChart("No PMTs with PCR found, nothing to display in this graph"));
                } else {
                    this.serviceChooser.addActionListener(this);
                    this.updateChartPanel();
                }
            }
        }
    }

    private static String getServiceName(TransportStream transportStream, int programNumber) {
        return transportStream.getPsi().getSdt().getServiceNameForActualTransportStreamOptional(programNumber).orElse("Service " + programNumber);
    }

    private void updateChartPanel() {
        this.freeChart = this.createChart(this.serviceChooser.getSelectedIndex());
        this.chartPanel.setChart(this.freeChart);
        this.freeChart.getLegend().setVisible(this.legendVisible);
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        this.fillSelectionPanels();
    }

    private void fillSelectionPanels() {
        XYPlot plot = (XYPlot)this.freeChart.getPlot();
        this.seriesSelectionPanel.removeAll();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        XYDataset dataset = plot.getDataset();
        TimeStampChart.createCheckBoxForSeries(this.seriesSelectionPanel, renderer, dataset);
        this.temiSelectionPanel.removeAll();
        XYDataset temiDataset = plot.getDataset(1);
        if (temiDataset != null) {
            XYLineAndShapeRenderer temiRenderer = (XYLineAndShapeRenderer)plot.getRenderer(1);
            TimeStampChart.createCheckBoxForSeries(this.temiSelectionPanel, temiRenderer, temiDataset);
        }
        this.seriesSelectionPanel.revalidate();
        this.temiSelectionPanel.revalidate();
    }

    private static void createCheckBoxForSeries(JPanel selectionPanel, XYLineAndShapeRenderer renderer, XYDataset dataset) {
        int count = dataset.getSeriesCount();
        for (int i = 0; i < count; ++i) {
            String label = (String)((Object)dataset.getSeriesKey(i));
            JCheckBox cb1 = new JCheckBox(label, true);
            cb1.addActionListener(actionEvent -> {
                JCheckBox source = (JCheckBox)actionEvent.getSource();
                int index = dataset.indexOf((Comparable)((Object)label));
                renderer.setSeriesVisible(index, Boolean.valueOf(source.isSelected()));
            });
            selectionPanel.validate();
            selectionPanel.add(cb1);
            if (i >= count - 1) continue;
            selectionPanel.add(Box.createHorizontalStrut(20));
        }
    }

    private JFreeChart createChart(int selectedIndex) {
        boolean hasTEMIData;
        XYDataset categoryTableXYDataset = this.createDataSet(selectedIndex);
        PMTsection section = this.pmts.get(selectedIndex);
        String serviceLabel = TimeStampChart.getServiceName(this.transportStream, section.getProgramNumber());
        JFreeChart chart = ChartFactory.createScatterPlot((String)("PCR/PTS/DTS Graph - " + serviceLabel), (String)"Time/packet no.", (String)"pcr/pts/dts value", (XYDataset)categoryTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setDrawingSupplier((DrawingSupplier)new DVBInspectorDefaultDrawingSupplier());
        plot.setRangePannable(true);
        plot.setDomainPannable(true);
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        TimeStampChart.useBlackOutlinePaint(categoryTableXYDataset, renderer);
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator("<htmL>{0}<br\\>{1}<br\\>value: {2}</html>", (NumberFormat)this.packetTimeNumberFormatLabel, (NumberFormat)this.timeStampNumberFormat);
        renderer.setDefaultToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setAutoRange(true);
        rangeAxis.setAutoRangeIncludesZero(false);
        NumberAxis xAxis = (NumberAxis)plot.getDomainAxis();
        xAxis.setNumberFormatOverride((NumberFormat)this.packetTimeNumberFormat);
        rangeAxis.setNumberFormatOverride((NumberFormat)this.timeStampNumberFormat);
        XYDataset temiDataset = this.createTEMIDataset(selectedIndex);
        boolean bl = hasTEMIData = temiDataset.getSeriesCount() > 0;
        if (hasTEMIData) {
            NumberAxis axis2 = new NumberAxis("TEMI");
            axis2.setAutoRangeIncludesZero(false);
            axis2.setLabelFont(rangeAxis.getLabelFont());
            axis2.setNumberFormatOverride((NumberFormat)this.temiNumberFormat);
            plot.setRangeAxis(1, (ValueAxis)axis2);
            plot.setDataset(1, temiDataset);
            plot.mapDatasetToRangeAxis(1, 1);
            XYLineAndShapeRenderer renderer2 = new XYLineAndShapeRenderer(false, true);
            TimeStampChart.useBlackOutlinePaint(temiDataset, renderer2);
            TEMIToolTipGenerator temiToolTipGenerator = new TEMIToolTipGenerator(this.temiNumberFormat);
            renderer2.setDefaultToolTipGenerator((XYToolTipGenerator)temiToolTipGenerator);
            plot.setRenderer(1, (XYItemRenderer)renderer2);
        }
        return chart;
    }

    private static void useBlackOutlinePaint(XYDataset categoryTableXYDataset, XYLineAndShapeRenderer renderer) {
        int seriesCount = categoryTableXYDataset.getSeriesCount();
        for (int i = 0; i < seriesCount; ++i) {
            renderer.setSeriesOutlinePaint(i, (Paint)Color.black);
        }
        renderer.setUseOutlinePaint(true);
    }

    private XYDataset createDataSet(int selectedIndex) {
        PMTsection pmt = this.pmts.get(selectedIndex);
        return new TimestampXYDataset(pmt, this.transportStream, this.viewContext);
    }

    private XYDataset createTEMIDataset(int selectedIndex) {
        PMTsection pmt = this.pmts.get(selectedIndex);
        return new TEMIXYDataset(pmt, this.transportStream, this.viewContext);
    }

    private void addLegendRadioButtons(JPanel buttonPanel) {
        JLabel typeLabel = new JLabel("Legend:");
        buttonPanel.add(typeLabel);
        JRadioButton onButton = new JRadioButton("On");
        onButton.addActionListener(e -> {
            if (!this.legendVisible) {
                this.legendVisible = true;
                if (this.freeChart != null) {
                    this.freeChart.getLegend().setVisible(this.legendVisible);
                }
            }
        });
        JRadioButton offButton = new JRadioButton("Off");
        offButton.addActionListener(e -> {
            if (this.legendVisible) {
                this.legendVisible = false;
                if (this.freeChart != null) {
                    this.freeChart.getLegend().setVisible(this.legendVisible);
                }
            }
        });
        onButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(onButton);
        group.add(offButton);
        buttonPanel.add(onButton);
        buttonPanel.add(offButton);
    }

    private void addTimePacketNoRadioButtons(JPanel buttonPanel) {
        JLabel typeLabel = new JLabel("X-Axis:");
        buttonPanel.add(typeLabel);
        this.timeButton = new JRadioButton("Time");
        this.timeButton.addActionListener(e -> {
            if (!this.usepacketTime) {
                this.usepacketTime = true;
                if (this.freeChart != null) {
                    this.freeChart.fireChartChanged();
                }
            }
        });
        this.packetNoButton = new JRadioButton("Packet No.");
        this.packetNoButton.addActionListener(e -> {
            if (this.usepacketTime) {
                this.usepacketTime = false;
                if (this.freeChart != null) {
                    this.freeChart.fireChartChanged();
                }
            }
        });
        this.timeButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.timeButton);
        group.add(this.packetNoButton);
        buttonPanel.add(this.timeButton);
        buttonPanel.add(this.packetNoButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.updateChartPanel();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void refreshView() {
        this.repaint();
    }

    public final class PacketTimeNumberFormat
    extends NumberFormat {
        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            String s = TimeStampChart.this.usepacketTime ? TimeStampChart.this.transportStream.getShortPacketTime(number) : Long.toString(number);
            return toAppendTo.append(s);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            String s = TimeStampChart.this.usepacketTime ? TimeStampChart.this.transportStream.getShortPacketTime((long)number) : Long.toString((long)number);
            return toAppendTo.append(s);
        }
    }

    public final class PacketTimeNumberFormatLabel
    extends NumberFormat {
        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            String label = TimeStampChart.this.usepacketTime ? "Packet Time: " : "Packet No: ";
            String s = TimeStampChart.this.packetTimeNumberFormat.format(number);
            return toAppendTo.append(label).append(s);
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            String label = TimeStampChart.this.usepacketTime ? "Time: " : "Packet No: ";
            String s = TimeStampChart.this.packetTimeNumberFormat.format(number);
            return toAppendTo.append(label).append(s);
        }
    }

    class HoverCopyAction
    extends AbstractAction {
        HoverCopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Point p = TimeStampChart.this.chartPanel.getMousePosition();
            String htmlString = TimeStampChart.this.chartPanel.getToolTipText(new MouseEvent((Component)TimeStampChart.this.chartPanel, 0, System.currentTimeMillis(), 0, p.x, p.y, 0, false));
            String plainData = Utils.extractTextFromHTML(htmlString);
            TextHTMLTransferable transferable = new TextHTMLTransferable(plainData, htmlString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(transferable, null);
        }
    }
}

