/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;

public final class GuiUtils {
    public static final String NO_TRANSPORTSTREAM_LOADED = "No transportstream loaded, drag a MPEG-TS (*.ts;*.mpg;*.mpeg;*.m2ts;*.mts;*.tsa;*.tsv) file here";

    private GuiUtils() {
    }

    public static JFreeChart createTitleOnlyChart(String title) {
        Plot plot = new Plot(){

            public String getPlotType() {
                return "message";
            }

            public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
            }
        };
        return new JFreeChart(title, plot);
    }

    public static KVP getNotImplementedKVP(String feature) {
        StringBuilder message = new StringBuilder();
        message.append(feature).append(" not implemented. ").append(GuiUtils.getImproveMsg());
        return new KVP(message.toString()).setHtmlLabel("<span style=\"color: red;\">" + String.valueOf(message) + "</span>");
    }

    public static KVP getErrorKVP(String message) {
        return new KVP(message).setHtmlLabel("<span style=\"color: red;\">" + message + "</span>");
    }

    public static String getImproveMsg() {
        String version = GuiUtils.getVersionString();
        return "You can help to improve DVB Inspector by making this stream available\nto Eric Berendsen (e_berendsen@digitalekabeltelevisie.nl)\n\nPlease include the version of DVB Inspector: " + version;
    }

    public static String getVersionString() {
        Package p = GuiUtils.class.getPackage();
        String version = p.getImplementationVersion();
        if (version == null) {
            version = "development version (unreleased)";
        }
        return version;
    }

    public static BufferedImage getErrorImage(String str) {
        int width = 800;
        int height = 450;
        BufferedImage img = new BufferedImage(800, 450, 1);
        Graphics2D gd = img.createGraphics();
        gd.setColor(Color.GRAY);
        gd.fillRect(0, 0, 800, 450);
        Color[] testBarColors = new Color[]{Color.WHITE, Color.YELLOW, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.RED, Color.BLUE, Color.BLACK};
        int barsHeight = 40;
        for (int i = 0; i < testBarColors.length; ++i) {
            gd.setColor(testBarColors[i]);
            gd.fillRect(i * 800 / 8, 0, 100, barsHeight);
            gd.fillRect(i * 800 / 8, 450 - barsHeight, 100, barsHeight);
        }
        gd.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("Arial", 1, 20);
        gd.setFont(font);
        gd.setColor(Color.WHITE);
        int x = 20;
        int y = 100;
        for (String line : str.split("\n")) {
            gd.drawString(line, x, y += gd.getFontMetrics().getHeight());
        }
        return img;
    }

    public static JFileChooser createFileChooser() {
        return GuiUtils.createFileChooser(List.of());
    }

    public static JFileChooser createFileChooser(List<FileNameExtensionFilter> fileNameExtensionFilters) {
        JFileChooser chooser = new JFileChooser();
        for (FileNameExtensionFilter fileNameExtensionFilter : fileNameExtensionFilters) {
            chooser.addChoosableFileFilter(fileNameExtensionFilter);
        }
        chooser.setAcceptAllFileFilterUsed(fileNameExtensionFilters.isEmpty());
        String defaultDir = PreferencesManager.getSaveDir();
        if (defaultDir != null) {
            File defDir = new File(defaultDir);
            chooser.setCurrentDirectory(defDir);
        }
        return chooser;
    }
}

