/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.gui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.PsiSectionData;
import nl.digitalekabeltelevisie.data.mpeg.TimeStamp;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.psi.PMTsection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSection;
import nl.digitalekabeltelevisie.data.mpeg.psi.SpliceInfoSections;
import org.jfree.data.DomainOrder;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.xy.XYDataset;

public class TimestampXYDataset
implements XYDataset {
    private DatasetGroup group;
    private final List<List<TimeStamp>> seriesList = new ArrayList<List<TimeStamp>>();
    final ArrayList<String> seriesKeys = new ArrayList();
    private static final Logger logger = Logger.getLogger(TimestampXYDataset.class.getName());

    public TimestampXYDataset(PMTsection pmt, TransportStream transportStream, ViewContext viewContext) {
        short pcrPid = (short)pmt.getPcrPid();
        if (transportStream.getPID(pcrPid) != null) {
            String pcrLabel = pcrPid + " - " + transportStream.getShortLabel(pcrPid) + " PCR";
            this.addToSeriesList(transportStream.getPID(pcrPid).getPcrList(), pcrLabel);
        }
        boolean hasSCTE35 = PsiSectionData.hasSCTE35RegistrationDescriptor(pmt.getDescriptorList());
        for (PMTsection.Component component : pmt.getComponentenList()) {
            PID pid = transportStream.getPID((short)component.getElementaryPID());
            if (pid == null) continue;
            this.addToSeriesList(pid.getPtsList(), TimestampXYDataset.getComponentLabel(transportStream, component) + " PTS");
            this.addToSeriesList(pid.getDtsList(), TimestampXYDataset.getComponentLabel(transportStream, component) + " DTS");
            this.findSCTE35Points(transportStream, hasSCTE35, component);
        }
    }

    private void findSCTE35Points(TransportStream transportStream, boolean hasSCTE35, PMTsection.Component component) {
        if (hasSCTE35 && component.getStreamtype() == 134) {
            ArrayList<TimeStamp> exitPoints = new ArrayList<TimeStamp>();
            ArrayList<TimeStamp> returnPoints = new ArrayList<TimeStamp>();
            ArrayList<TimeStamp> timeSignalPoints = new ArrayList<TimeStamp>();
            SpliceInfoSections spliceSections = transportStream.getPsi().getScte35_table().getSpliceInfoSections((short)component.getElementaryPID());
            if (spliceSections != null) {
                TimestampXYDataset.findSpliceInserts(exitPoints, returnPoints, timeSignalPoints, spliceSections);
                this.addToSeriesList(exitPoints, TimestampXYDataset.getComponentLabel(transportStream, component) + " Exit Point");
                this.addToSeriesList(returnPoints, TimestampXYDataset.getComponentLabel(transportStream, component) + " Return Point");
                this.addToSeriesList(timeSignalPoints, TimestampXYDataset.getComponentLabel(transportStream, component) + " time_signal");
            }
        }
    }

    private static void findSpliceInserts(List<TimeStamp> exitPoints, List<TimeStamp> returnPoints, List<TimeStamp> timeSignalPoints, SpliceInfoSections spliceSections) {
        List<SpliceInfoSection> spliceInfoSectionList = spliceSections.getSpliceInfoSectionList();
        for (SpliceInfoSection spliceSection : spliceInfoSectionList) {
            SpliceInfoSection.TimeSignal timeSignal;
            SpliceInfoSection.SpliceTime spliceTime;
            if (spliceSection.getSplice_command_type() == 5) {
                SpliceInfoSection.SpliceInsert spliceInsert = (SpliceInfoSection.SpliceInsert)spliceSection.getSplice_command();
                if (spliceInsert.getSplice_immediate_flag() != 0) continue;
                if (spliceInsert.getProgram_splice_flag() == 1) {
                    TimestampXYDataset.handleProgramSplicePoint(exitPoints, returnPoints, spliceSection, spliceInsert);
                    continue;
                }
                logger.warning("SCTE35 Component Splice Mode not yet supported, please report");
                continue;
            }
            if (spliceSection.getSplice_command_type() != 6 || (spliceTime = (timeSignal = (SpliceInfoSection.TimeSignal)spliceSection.getSplice_command()).getSplice_time()) == null || spliceTime.getTime_specified_flag() != 1) continue;
            TimeStamp ts = new TimeStamp(spliceSection.getPacket_no(), spliceTime.getSpliceTimeAdjusted());
            timeSignalPoints.add(ts);
        }
    }

    private static void handleProgramSplicePoint(List<TimeStamp> exitPoints, List<TimeStamp> returnPoints, SpliceInfoSection spliceSection, SpliceInfoSection.SpliceInsert spliceInsert) {
        SpliceInfoSection.SpliceTime spliceTime = spliceInsert.getSplice_time();
        if (spliceTime != null && spliceTime.getTime_specified_flag() == 1) {
            TimeStamp ts = new TimeStamp(spliceSection.getPacket_no(), spliceTime.getSpliceTimeAdjusted());
            if (spliceInsert.getOut_of_network_indicator() == 1) {
                exitPoints.add(ts);
            } else {
                returnPoints.add(ts);
            }
        }
    }

    private static String getComponentLabel(TransportStream transportStream, PMTsection.Component component) {
        return (short)component.getElementaryPID() + " - " + transportStream.getShortLabel((short)component.getElementaryPID());
    }

    private void addToSeriesList(List<TimeStamp> list, String componentLabel) {
        if (list != null && !list.isEmpty()) {
            this.seriesList.add(list);
            this.seriesKeys.add(componentLabel);
        }
    }

    public int getSeriesCount() {
        return this.seriesList.size();
    }

    public Comparable<?> getSeriesKey(int series) {
        return (Comparable)((Object)this.seriesKeys.get(series));
    }

    public int indexOf(Comparable seriesKey) {
        return this.seriesKeys.indexOf(seriesKey);
    }

    public void addChangeListener(DatasetChangeListener listener) {
    }

    public void removeChangeListener(DatasetChangeListener listener) {
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup group) {
        this.group = group;
    }

    public DomainOrder getDomainOrder() {
        return DomainOrder.ASCENDING;
    }

    public int getItemCount(int series) {
        return this.seriesList.get(series).size();
    }

    public Number getX(int series, int item) {
        return this.seriesList.get(series).get(item).x();
    }

    public double getXValue(int series, int item) {
        return this.seriesList.get(series).get(item).x();
    }

    public Number getY(int series, int item) {
        return this.seriesList.get(series).get(item).time();
    }

    public double getYValue(int series, int item) {
        return this.seriesList.get(series).get(item).time();
    }
}

