/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.main;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.digitalekabeltelevisie.controller.ChartLabel;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.controller.ViewContext;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.data.mpeg.pes.GeneralPidHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.AC3Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ac3.EAC3Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.Audio138183Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.audio.aac.Audio144963Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.dvbsubtitling.DVBSubtitleHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.ebu.EBUTeletextHandler;
import nl.digitalekabeltelevisie.data.mpeg.pes.smpte.Smpte2038Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video.Video138182Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video264.Video14496Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video265.H265Handler;
import nl.digitalekabeltelevisie.data.mpeg.pes.video266.H266Handler;
import nl.digitalekabeltelevisie.data.mpeg.pid.t2mi.T2miPidHandler;
import nl.digitalekabeltelevisie.gui.AboutAction;
import nl.digitalekabeltelevisie.gui.BarChart;
import nl.digitalekabeltelevisie.gui.BitRateChart;
import nl.digitalekabeltelevisie.gui.ClearRecentFilesAction;
import nl.digitalekabeltelevisie.gui.DVBtree;
import nl.digitalekabeltelevisie.gui.EITView;
import nl.digitalekabeltelevisie.gui.EnableDSMCCAction;
import nl.digitalekabeltelevisie.gui.EnableGenericPSIAction;
import nl.digitalekabeltelevisie.gui.EnableHumaxAtsFixAction;
import nl.digitalekabeltelevisie.gui.EnableM7FastscanAction;
import nl.digitalekabeltelevisie.gui.EnablePcrPtsViewAction;
import nl.digitalekabeltelevisie.gui.FileDropHandler;
import nl.digitalekabeltelevisie.gui.FileOpenAction;
import nl.digitalekabeltelevisie.gui.FindAction;
import nl.digitalekabeltelevisie.gui.FindNextAction;
import nl.digitalekabeltelevisie.gui.GridView;
import nl.digitalekabeltelevisie.gui.PIDDialog;
import nl.digitalekabeltelevisie.gui.PIDDialogOpenAction;
import nl.digitalekabeltelevisie.gui.RecentFileOpenAction;
import nl.digitalekabeltelevisie.gui.SetG0DefaultAction;
import nl.digitalekabeltelevisie.gui.SetPacketLengthAction;
import nl.digitalekabeltelevisie.gui.SetPrivateDataSpecifierAction;
import nl.digitalekabeltelevisie.gui.TimeStampChart;
import nl.digitalekabeltelevisie.gui.TimestampFormatAction;
import nl.digitalekabeltelevisie.gui.ToggleViewAction;
import nl.digitalekabeltelevisie.gui.TransportStreamView;
import nl.digitalekabeltelevisie.gui.exception.NotAnMPEGFileException;
import nl.digitalekabeltelevisie.gui.utils.RecentFiles;
import nl.digitalekabeltelevisie.util.DefaultMutableTreeNodePreorderEnumaration;
import nl.digitalekabeltelevisie.util.PreferencesManager;
import nl.digitalekabeltelevisie.util.Utils;
import org.jfree.chart.plot.DefaultDrawingSupplier;

public class DVBinspector
implements ChangeListener,
ActionListener {
    private static final Logger LOGGER = Logger.getLogger(DVBinspector.class.getName());
    private TransportStream transportStream;
    private JFrame frame;
    private final List<TransportStreamView> views = new ArrayList<TransportStreamView>();
    private DVBtree treeView;
    private TimeStampChart timeStampChart;
    private BitRateChart bitRateView;
    private BarChart barChart;
    private GridView gridView;
    private JTabbedPane tabbedPane;
    private JMenu viewTreeMenu;
    private JMenu viewMenu;
    private JMenu recentFilesMenu;
    private PIDDialog pidDialog = null;
    private ViewContext viewContext = new ViewContext();
    private int modus;
    private FindNextAction findNextAction;
    private DefaultMutableTreeNodePreorderEnumaration searchEnummeration;
    private String searchString;

    public static void main(String[] args) {
        DVBinspector inspector = new DVBinspector();
        if (args.length >= 1) {
            String filename = args[0];
            try {
                TransportStream ts;
                inspector.transportStream = ts = new TransportStream(filename);
                inspector.transportStream.parseStream(null);
                if (args.length >= 2) {
                    Map<Integer, GeneralPidHandler> pidHandlerMap = DVBinspector.determinePidHandlers(args, ts);
                    ts.parsePidStreams(pidHandlerMap);
                }
            }
            catch (NotAnMPEGFileException e) {
                LOGGER.log(Level.WARNING, "error determining packetsize transportStream", e);
            }
            catch (Throwable e) {
                LOGGER.log(Level.WARNING, "error parsing transportStream", e);
            }
        }
        inspector.run();
    }

    public static Map<Integer, GeneralPidHandler> determinePidHandlers(String[] args, TransportStream ts) throws ReflectiveOperationException {
        Class<? extends GeneralPidHandler> forcedHandlerClass = null;
        PID[] pids = ts.getPids();
        HashMap<Integer, GeneralPidHandler> pidHandlerMap = new HashMap<Integer, GeneralPidHandler>();
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-")) {
                forcedHandlerClass = null;
                continue;
            }
            if (args[i].startsWith("-")) {
                forcedHandlerClass = PidHandlers.valueOf(args[i].substring(1)).getPidHandler();
                continue;
            }
            int pid = Integer.parseInt(args[i]);
            PID p = pids[pid];
            if (p == null) continue;
            if (forcedHandlerClass == null) {
                pidHandlerMap.put(pid, p.getPidHandler());
                continue;
            }
            GeneralPidHandler handlerInstance = forcedHandlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            handlerInstance.setPID(p);
            handlerInstance.setTransportStream(ts);
            p.setPidHandler(handlerInstance);
            pidHandlerMap.put(pid, handlerInstance);
        }
        return pidHandlerMap;
    }

    public void run() {
        KVP.setNumberDisplay(KVP.NUMBER_DISPLAY.BOTH);
        KVP.setStringDisplay(KVP.STRING_DISPLAY.HTML_AWT);
        SwingUtilities.invokeLater(() -> this.createAndShowGUI(this.transportStream));
    }

    private void createAndShowGUI(TransportStream tStream) {
        int modus = PreferencesManager.getDefaultViewModus();
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        this.frame = new JFrame("DVB Inspector");
        this.frame.setDefaultCloseOperation(3);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DVBinspector.this.saveWindowState();
                super.windowClosing(e);
            }
        });
        this.pidDialog = new PIDDialog((Frame)this.frame, this.viewContext, this);
        this.updatePIDLists(tStream, this.pidDialog);
        this.tabbedPane = new JTabbedPane();
        this.treeView = new DVBtree(tStream, modus, this);
        this.tabbedPane.addTab("Tree", this.treeView);
        this.tabbedPane.setMnemonicAt(0, 49);
        this.views.add(this.treeView);
        EITView eitView = new EITView(tStream, this.viewContext);
        this.tabbedPane.addTab("EIT View", eitView);
        this.views.add(eitView);
        this.tabbedPane.setMnemonicAt(1, 50);
        this.bitRateView = new BitRateChart(tStream, this.viewContext);
        this.tabbedPane.addTab("BitRate View", this.bitRateView);
        this.tabbedPane.setMnemonicAt(2, 51);
        this.views.add(this.bitRateView);
        this.barChart = new BarChart(tStream, this.viewContext);
        this.tabbedPane.addTab("Bar View", (Component)((Object)this.barChart));
        this.tabbedPane.setMnemonicAt(3, 52);
        this.views.add(this.barChart);
        this.gridView = new GridView(tStream, this.viewContext);
        this.tabbedPane.addTab("Grid View", this.gridView);
        this.tabbedPane.setMnemonicAt(4, 53);
        this.views.add(this.gridView);
        this.timeStampChart = new TimeStampChart(tStream, this.viewContext);
        this.tabbedPane.addTab("PCR/PTS/DTS View", this.timeStampChart);
        this.tabbedPane.setMnemonicAt(5, 54);
        this.views.add(this.timeStampChart);
        this.tabbedPane.validate();
        this.tabbedPane.addChangeListener(this);
        this.tabbedPane.setTransferHandler(new FileDropHandler(this));
        this.frame.add(this.tabbedPane);
        this.frame.setJMenuBar(this.createMenuBar(modus));
        this.enableViewMenus();
        Image image = Utils.readIconImage("magnifying_glass.bmp");
        this.frame.setIconImage(image);
        this.frame.setBounds(DVBinspector.calculateBounds());
        this.frame.setVisible(true);
    }

    private JMenuBar createMenuBar(int modus) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        this.viewTreeMenu = this.createViewTreeMenu(modus);
        menuBar.add(this.viewTreeMenu);
        this.viewMenu = this.createViewMenu();
        menuBar.add(this.viewMenu);
        menuBar.add(this.createSettingsMenu());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private static Rectangle calculateBounds() {
        int x = Math.max(0, PreferencesManager.getWindowX());
        int y = Math.max(0, PreferencesManager.getWindowY());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        x = Math.min(screenWidth - 200, x);
        y = Math.min(screenHeight - 200, y);
        int w = Math.min(screenWidth, PreferencesManager.getWindowWidth());
        int h = Math.min(screenHeight, PreferencesManager.getWindowHeight());
        return new Rectangle(x, y, w, h);
    }

    private JMenu createSettingsMenu() {
        JMenu settingsMenu = new JMenu("Settings");
        settingsMenu.setMnemonic(83);
        JMenu packetLengthSubMenu = new JMenu("Packet Size");
        packetLengthSubMenu.setMnemonic(73);
        ButtonGroup packetLengthMenuGroup = new ButtonGroup();
        this.addPacketLengthMenuItem(packetLengthSubMenu, packetLengthMenuGroup, "auto (Recommended)", 0);
        for (int i : TransportStream.ALLOWED_PACKET_LENGTHS) {
            this.addPacketLengthMenuItem(packetLengthSubMenu, packetLengthMenuGroup, i + (i == 192 ? " (AVCHD/Blu-ray)" : ""), i);
        }
        settingsMenu.add(packetLengthSubMenu);
        JMenu privateDataSubMenu = new JMenu("Private Data Specifier Default");
        privateDataSubMenu.setMnemonic(83);
        ButtonGroup privateDataSpecifierMenuGroup = new ButtonGroup();
        long defaultPrivateDataSpecifier = PreferencesManager.getDefaultPrivateDataSpecifier();
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 0L, "none", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 1L, "SES", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 22L, "Casema", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 40L, "EACEM", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 41L, "Nordig", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 64L, "CI Plus LLP", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 164L, "CANAL+ INTERNATIONAL", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 1536L, "UPC", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 9018L, "Independent Television Commission (DTG)", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 12800L, "Australian Terrestrial Television Networks", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 1096176470L, "Audio Video Coding Standard Workgroup of China (AVS3 video)", defaultPrivateDataSpecifier);
        this.addPrivateDataSpecMenuItem(privateDataSubMenu, privateDataSpecifierMenuGroup, 1096176449L, "Audio Video Coding Standard Workgroup of China (AVS3 audio)", defaultPrivateDataSpecifier);
        settingsMenu.add(privateDataSubMenu);
        JMenu defaultG0andG2CharacterSetDesignationMenu = new JMenu("Teletext Default G0 and G2 Character Set Designation");
        defaultG0andG2CharacterSetDesignationMenu.setMnemonic(84);
        ButtonGroup g0Group = new ButtonGroup();
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 0, "0 0 0 0 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 1, "0 0 0 1 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 2, "0 0 1 0 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 3, "0 0 1 1 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 4, "0 1 0 0 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 5, "0 1 0 1 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 6, "0 1 1 0 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 7, "0 1 1 1 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 8, "1 0 0 0 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 9, "1 0 0 1 x x x");
        this.addG0CharacterSet(defaultG0andG2CharacterSetDesignationMenu, g0Group, 10, "1 0 1 0 x x x");
        settingsMenu.add(defaultG0andG2CharacterSetDesignationMenu);
        JCheckBoxMenuItem enableM7Fastscan = new JCheckBoxMenuItem(new EnableM7FastscanAction(this));
        enableM7Fastscan.setMnemonic(77);
        enableM7Fastscan.setSelected(PreferencesManager.isEnableM7Fastscan());
        settingsMenu.add(enableM7Fastscan);
        JCheckBoxMenuItem enableHumaxAtsFix = new JCheckBoxMenuItem(new EnableHumaxAtsFixAction(this));
        enableHumaxAtsFix.setMnemonic(72);
        enableHumaxAtsFix.setSelected(PreferencesManager.isEnableHumaxAtsFix());
        settingsMenu.add(enableHumaxAtsFix);
        settingsMenu.addSeparator();
        JCheckBoxMenuItem enableGenericPSI = new JCheckBoxMenuItem(new EnableGenericPSIAction(this));
        enableGenericPSI.setMnemonic(71);
        enableGenericPSI.setSelected(PreferencesManager.isEnableGenericPSI());
        settingsMenu.add(enableGenericPSI);
        JCheckBoxMenuItem enableDSMCC = new JCheckBoxMenuItem(new EnableDSMCCAction(this));
        enableDSMCC.setMnemonic(68);
        enableDSMCC.setSelected(PreferencesManager.isEnableDSMCC());
        settingsMenu.add(enableDSMCC);
        JCheckBoxMenuItem enablePcrPtsView = new JCheckBoxMenuItem(new EnablePcrPtsViewAction(this));
        enablePcrPtsView.setMnemonic(80);
        enablePcrPtsView.setSelected(PreferencesManager.isEnablePcrPtsView());
        settingsMenu.add(enablePcrPtsView);
        JMenu timestampPresentationMenu = new JMenu("Timestamp format");
        timestampPresentationMenu.setMnemonic(84);
        boolean showSeconds = PreferencesManager.getEnableSecondsTimestamp();
        ButtonGroup tsFormatGroup = new ButtonGroup();
        JRadioButtonMenuItem hhmmssItem = new JRadioButtonMenuItem("hh:mm:ss.SSS");
        tsFormatGroup.add(hhmmssItem);
        hhmmssItem.addActionListener(new TimestampFormatAction(this, false));
        hhmmssItem.setSelected(!showSeconds);
        timestampPresentationMenu.add(hhmmssItem);
        JRadioButtonMenuItem secondsItem = new JRadioButtonMenuItem("seconds.SSS");
        tsFormatGroup.add(secondsItem);
        secondsItem.addActionListener(new TimestampFormatAction(this, true));
        secondsItem.setSelected(showSeconds);
        timestampPresentationMenu.add(secondsItem);
        settingsMenu.add(timestampPresentationMenu);
        return settingsMenu;
    }

    private void addPacketLengthMenuItem(JMenu packetLengthSubMenu, ButtonGroup packetLengthMenuGroup, String description, int length) {
        JRadioButtonMenuItem packetLengthItem = new JRadioButtonMenuItem(description);
        packetLengthMenuGroup.add(packetLengthItem);
        packetLengthItem.addActionListener(new SetPacketLengthAction(this, length));
        packetLengthItem.setSelected(PreferencesManager.getPacketLengthModus() == length);
        packetLengthSubMenu.add(packetLengthItem);
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        PIDDialogOpenAction pidOpenAction = new PIDDialogOpenAction(this.pidDialog, this.frame, this);
        JMenuItem filterItem = new JMenuItem(pidOpenAction);
        filterItem.setMnemonic(70);
        viewMenu.add(filterItem);
        return viewMenu;
    }

    private JMenu createHelpMenu() {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        AboutAction aboutAction = new AboutAction(this.frame);
        JMenuItem aboutMenuItem = new JMenuItem(aboutAction);
        aboutMenuItem.setMnemonic(65);
        helpMenu.add(aboutMenuItem);
        return helpMenu;
    }

    private JMenu createViewTreeMenu(int modus) {
        JMenu viewTreeMenu = new JMenu("Tree View");
        viewTreeMenu.setMnemonic(84);
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "Simple Tree View", 1, 83));
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "PSI Only", 2, 80));
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "Packet Count", 4, 67));
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "Number List Items", 8, 78));
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "Show PTS on PES Packets", 16, 84));
        viewTreeMenu.add(this.createCheckBoxMenuItem(modus, "Show version_number on Table Sections", 32, 86));
        FindAction findAction = new FindAction(this);
        JMenuItem findMenuItem = new JMenuItem(findAction);
        findMenuItem.setMnemonic(70);
        findMenuItem.setAccelerator(KeyStroke.getKeyStroke(70, 128));
        this.findNextAction = new FindNextAction(this);
        JMenuItem findNextMenuItem = new JMenuItem(this.findNextAction);
        findNextMenuItem.setMnemonic(78);
        findNextMenuItem.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.findNextAction.setEnabled(false);
        viewTreeMenu.addSeparator();
        viewTreeMenu.add(findMenuItem);
        viewTreeMenu.add(findNextMenuItem);
        return viewTreeMenu;
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(int modus, String label, int modusBit, int vkS) {
        JCheckBoxMenuItem viewMenu = new JCheckBoxMenuItem(new ToggleViewAction(label, this, modusBit));
        viewMenu.setMnemonic(vkS);
        viewMenu.setSelected((modus & modusBit) != 0);
        return viewMenu;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        FileOpenAction fileOpenAction = new FileOpenAction(this);
        JMenuItem openMenuItem = new JMenuItem(fileOpenAction);
        openMenuItem.setMnemonic(79);
        openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        fileMenu.add(openMenuItem);
        this.recentFilesMenu = this.createRecentFilesMenu();
        fileMenu.add(this.recentFilesMenu);
        JMenuItem exitMenuItem = new JMenuItem("Exit", 88);
        exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 128));
        exitMenuItem.addActionListener(this);
        fileMenu.add(exitMenuItem);
        return fileMenu;
    }

    private JMenu createRecentFilesMenu() {
        JMenu recentFilesMenu = new JMenu("Recent Files");
        recentFilesMenu.setMnemonic(82);
        this.populateRecenFilesMenu(recentFilesMenu);
        return recentFilesMenu;
    }

    private void populateRecenFilesMenu(JMenu recentFilesMenu) {
        this.addFilesToMenu(recentFilesMenu);
        recentFilesMenu.addSeparator();
        JMenuItem clearRecentFilesMenuItem = new JMenuItem("Empty Recent Files List", 69);
        clearRecentFilesMenuItem.addActionListener(new ClearRecentFilesAction(this));
        recentFilesMenu.add(clearRecentFilesMenuItem);
    }

    private void addFilesToMenu(JMenu recentFilesMenu) {
        RecentFiles recent = RecentFiles.getInstance();
        List<String> files = recent.getRecentFiles();
        int no = 1;
        for (String f : files) {
            RecentFileOpenAction recentAction = new RecentFileOpenAction(this, f, no);
            JMenuItem fileMenuItem = new JMenuItem(recentAction);
            String numberString = Integer.toString(no);
            int mnemonic = numberString.codePointAt(numberString.length() - 1);
            fileMenuItem.setMnemonic(mnemonic);
            recentFilesMenu.add(fileMenuItem);
            ++no;
        }
    }

    private void addPrivateDataSpecMenuItem(JMenu privateDataSubMenu, ButtonGroup group, long spec, String name, long defaultSpecifier) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(Utils.toHexString(spec, 8) + " - " + name);
        group.add(menuItem);
        menuItem.addActionListener(new SetPrivateDataSpecifierAction(this, spec));
        menuItem.setSelected(spec == defaultSpecifier);
        privateDataSubMenu.add(menuItem);
    }

    private void addG0CharacterSet(JMenu privateDataSubMenu, ButtonGroup group, int spec, String name) {
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(name);
        group.add(menuItem);
        menuItem.addActionListener(new SetG0DefaultAction(this, spec));
        menuItem.setSelected(spec == PreferencesManager.getDefaultG0CharacterSet());
        privateDataSubMenu.add(menuItem);
    }

    public TransportStream getTransportStream() {
        return this.transportStream;
    }

    public void setTransportStream(TransportStream transportStream) {
        this.transportStream = transportStream;
        if (transportStream != null) {
            this.updatePIDLists(transportStream, this.pidDialog);
            this.frame.setTitle(transportStream.getFile().getName() + " - stream:" + transportStream.getStreamID() + " - DVB Inspector");
        }
        for (TransportStreamView v : this.views) {
            v.setTransportStream(transportStream, this.viewContext);
        }
        this.enableViewMenus();
    }

    public DVBtree getTreeView() {
        return this.treeView;
    }

    public void setTreeView(DVBtree treeView) {
        this.treeView = treeView;
    }

    private void updatePIDLists(TransportStream tStream, PIDDialog pDialog) {
        ViewContext viewConfig = new ViewContext();
        ArrayList<ChartLabel> used = new ArrayList<ChartLabel>();
        ArrayList<ChartLabel> notUsed = new ArrayList<ChartLabel>();
        if (tStream != null) {
            short[] used_pids = tStream.getUsedPids();
            for (int i = 0; i < used_pids.length; ++i) {
                short actualPid = used_pids[i];
                used.add(new ChartLabel(actualPid + " - " + this.transportStream.getShortLabel(actualPid), actualPid, DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[i % DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE.length]));
            }
            viewConfig.setStartPacket(0);
            viewConfig.setEndPacket(tStream.getNo_packets());
            viewConfig.setMaxPacket(tStream.getNo_packets());
            if (used_pids.length > 0) {
                int graphSteps = 20000 / used_pids.length;
                int stepsIndex = Arrays.binarySearch((Object[])PIDDialog.STEP_OPTIONS, (Object)graphSteps);
                if (stepsIndex < 0) {
                    stepsIndex = -(stepsIndex + 1);
                    stepsIndex = Math.min(6, stepsIndex);
                }
                viewConfig.setGraphSteps(PIDDialog.STEP_OPTIONS[stepsIndex]);
            }
        }
        viewConfig.setShown(used);
        viewConfig.setNotShown(notUsed);
        viewConfig.setTransportStream(tStream);
        this.viewContext = viewConfig;
        pDialog.setConfig(viewConfig);
    }

    public void setPIDList(ViewContext vContext) {
        this.viewContext = vContext;
        if (this.transportStream != null) {
            this.bitRateView.setTransportStream(this.transportStream, vContext);
            this.barChart.setTransportStream(this.transportStream, vContext);
            this.gridView.setTransportStream(this.transportStream, vContext);
            this.timeStampChart.setTransportStream(this.transportStream, vContext);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.enableViewMenus();
    }

    private void enableViewMenus() {
        int i = this.tabbedPane.getSelectedIndex();
        this.viewTreeMenu.setEnabled(i == 0 && this.transportStream != null);
        this.viewMenu.setEnabled(i > 1 && this.transportStream != null);
    }

    private void saveWindowState() {
        PreferencesManager.setWindowX(this.frame.getX());
        PreferencesManager.setWindowY(this.frame.getY());
        PreferencesManager.setWindowWidth(this.frame.getWidth());
        PreferencesManager.setWindowHeight(this.frame.getHeight());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.saveWindowState();
        System.exit(0);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public int getModus() {
        return this.modus;
    }

    public void setModus(int modus) {
        this.modus = modus;
    }

    public void setSearchEnumeration(DefaultMutableTreeNodePreorderEnumaration enummeration) {
        this.searchEnummeration = enummeration;
        if (enummeration == null) {
            this.findNextAction.setEnabled(false);
        } else if (this.searchString != null) {
            this.findNextAction.setEnabled(true);
        }
    }

    public DefaultMutableTreeNodePreorderEnumaration getSearchEnumeration() {
        return this.searchEnummeration;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
        if (searchString == null) {
            this.findNextAction.setEnabled(false);
        } else if (this.searchEnummeration != null) {
            this.findNextAction.setEnabled(true);
        }
    }

    public FindNextAction getFindNextAction() {
        return this.findNextAction;
    }

    public void resetSearch() {
        this.searchEnummeration = null;
        this.searchString = null;
        this.findNextAction.setEnabled(false);
    }

    public void refreshViews() {
        for (TransportStreamView view : this.views) {
            view.refreshView();
        }
    }

    public void addRecentFile(String fileName) {
        RecentFiles recentFiles = RecentFiles.getInstance();
        recentFiles.addOrMoveToBegin(fileName);
        this.recentFilesMenu.removeAll();
        this.populateRecenFilesMenu(this.recentFilesMenu);
    }

    public void removeRecentFile(String fileName) {
        RecentFiles recentFiles = RecentFiles.getInstance();
        if (recentFiles.remove(fileName)) {
            this.recentFilesMenu.removeAll();
            this.populateRecenFilesMenu(this.recentFilesMenu);
        }
    }

    public void clearRecentFiles() {
        RecentFiles recentFiles = RecentFiles.getInstance();
        recentFiles.reset();
        this.recentFilesMenu.removeAll();
        this.populateRecenFilesMenu(this.recentFilesMenu);
    }

    static enum PidHandlers {
        t2mi(T2miPidHandler.class),
        ac3(AC3Handler.class),
        eac3(EAC3Handler.class),
        mpeg2audio(Audio138183Handler.class),
        dvbsub(DVBSubtitleHandler.class),
        ttx(EBUTeletextHandler.class),
        h222(Video138182Handler.class),
        h264(Video14496Handler.class),
        h265(H265Handler.class),
        h266(H266Handler.class),
        aac(Audio144963Handler.class),
        smpte2038(Smpte2038Handler.class);

        private final Class<? extends GeneralPidHandler> pidHandler;

        private PidHandlers(Class<? extends GeneralPidHandler> a) {
            this.pidHandler = a;
        }

        Class<? extends GeneralPidHandler> getPidHandler() {
            return this.pidHandler;
        }
    }
}

