/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.gui.DVBtree;
import nl.digitalekabeltelevisie.util.PreferencesManager;

public class ExportTree {
    public static String tsDir = "I:\\regressiontests";
    public static String exportDir = "I:\\regresssionexportrefactoreddsmcc20231014";
    static Path baseDirPath = Paths.get(tsDir, new String[0]);
    static Path exportDirPath = Paths.get(exportDir, new String[0]);
    static File logFile = new File(exportDir, "log.txt");
    static PrintWriter log;

    public static void main(String[] args) throws IOException {
        log = new PrintWriter(logFile);
        PreferencesManager.setEnableDSMCC(true);
        PreferencesManager.setEnableGenericPSI(false);
        PreferencesManager.setEnablePcrPtsView(false);
        Path basePath = Paths.get(tsDir, new String[0]);
        Files.walk(basePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(t -> ExportTree.exportFile(t));
        log.close();
    }

    static void exportFile(Path filePath) {
        System.out.println("Path:" + String.valueOf(filePath));
        Path relativePath = baseDirPath.relativize(filePath);
        String newExtensionRelativePath = relativePath.toString() + ".txt";
        Path exportFile = exportDirPath.resolve(newExtensionRelativePath);
        Path parent = exportFile.getParent();
        if (!parent.toFile().exists()) {
            System.out.println("exportFile parent: does not exist:" + String.valueOf(parent));
            boolean succes = parent.toFile().mkdirs();
            System.out.println("dir created: " + succes);
        }
        File tsFile = filePath.toFile();
        try {
            TransportStream transportStream = new TransportStream(tsFile);
            transportStream.parseStream(null);
            KVP node = transportStream.getJTreeNode(2);
            KVP kvp = (KVP)((DefaultMutableTreeNode)node).getUserObject();
            String lineSep = System.getProperty("line.separator");
            StringBuilder res = new StringBuilder(kvp.getPlainText());
            res.append(lineSep);
            res.append((CharSequence)DVBtree.getEntireTree(node, ""));
            String treeString = res.toString();
            File exportTreeFile = exportFile.toFile();
            try (PrintWriter out = new PrintWriter(exportTreeFile, "UTF-8");){
                out.println(treeString);
            }
            log.println("Succes for  File:" + String.valueOf(filePath));
            log.flush();
        }
        catch (Throwable e) {
            log.println("Parsing error in File:" + String.valueOf(filePath) + ", exception:" + String.valueOf(e));
            log.flush();
            System.out.println("Parsing error in File:" + String.valueOf(filePath) + "excoption:" + String.valueOf(e));
        }
    }
}

