/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.Arrays;
import nl.digitalekabeltelevisie.controller.DVBString;
import nl.digitalekabeltelevisie.gui.HTMLSource;
import nl.digitalekabeltelevisie.util.Utils;

public class BitSource
implements HTMLSource {
    private final byte[] bytes;
    private int byteOffset = 0;
    private int bitOffset = 0;
    private final int lastBytePlusOne;
    public static final int[] powerOf2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};

    public BitSource(byte[] bytes, int offset) {
        this.bytes = bytes;
        this.byteOffset = offset;
        this.lastBytePlusOne = bytes.length;
    }

    public BitSource(byte[] bytes, int offset, int lastBytePlusOne) {
        this.bytes = bytes;
        this.byteOffset = offset;
        this.lastBytePlusOne = lastBytePlusOne;
    }

    public BitSource(BitSource src, int len) {
        this.bytes = src.bytes;
        this.byteOffset = src.byteOffset;
        this.bitOffset = src.bitOffset;
        this.lastBytePlusOne = src.byteOffset + len;
    }

    public BitSource(BitSource src) {
        this.bytes = src.bytes;
        this.byteOffset = src.byteOffset;
        this.bitOffset = src.bitOffset;
        this.lastBytePlusOne = src.lastBytePlusOne;
    }

    public int readBits(int bits) {
        int numBits = bits;
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        if (this.bitOffset > 0) {
            int bitsLeft = 8 - this.bitOffset;
            int toRead = Math.min(numBits, bitsLeft);
            int bitsToNotRead = bitsLeft - toRead;
            int mask = 255 >> 8 - toRead << bitsToNotRead;
            result = (this.bytes[this.byteOffset] & mask) >> bitsToNotRead;
            numBits -= toRead;
            this.bitOffset += toRead;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        while (numBits >= 8) {
            result = result << 8 | this.bytes[this.byteOffset] & 0xFF;
            ++this.byteOffset;
            numBits -= 8;
        }
        if (numBits > 0) {
            int bitsToNotRead = 8 - numBits;
            int mask = 255 >> bitsToNotRead << bitsToNotRead;
            result = result << numBits | (this.bytes[this.byteOffset] & mask) >> bitsToNotRead;
            this.bitOffset += numBits;
        }
        return result;
    }

    public long readBitsLong(int bits) {
        int numBits = bits;
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        long result = 0L;
        if (this.bitOffset > 0) {
            int bitsLeft = 8 - this.bitOffset;
            int toRead = Math.min(numBits, bitsLeft);
            int bitsToNotRead = bitsLeft - toRead;
            int mask = 255 >> 8 - toRead << bitsToNotRead;
            result = (this.bytes[this.byteOffset] & mask) >> bitsToNotRead;
            numBits -= toRead;
            this.bitOffset += toRead;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        while (numBits >= 8) {
            result = result << 8 | (long)(this.bytes[this.byteOffset] & 0xFF);
            ++this.byteOffset;
            numBits -= 8;
        }
        if (numBits > 0) {
            int bitsToNotRead = 8 - numBits;
            int mask = 255 >> bitsToNotRead << bitsToNotRead;
            result = result << numBits | (long)((this.bytes[this.byteOffset] & mask) >> bitsToNotRead);
            this.bitOffset += numBits;
        }
        return result;
    }

    public byte[] readBytes(int noBytes) {
        this.skiptoByteBoundary();
        if (noBytes > 0) {
            byte[] result = Arrays.copyOfRange(this.bytes, this.byteOffset, this.byteOffset + noBytes);
            this.byteOffset += noBytes;
            return result;
        }
        return new byte[0];
    }

    public byte[] readUnalignedBytes(int noBytes) {
        byte[] result = new byte[noBytes];
        for (int i = 0; i < noBytes; ++i) {
            result[i] = (byte)this.readBits(8);
        }
        return result;
    }

    public void advanceBytes(int number) {
        this.skiptoByteBoundary();
        this.byteOffset += number;
    }

    public void skiptoByteBoundary() {
        if (this.bitOffset > 0) {
            this.bitOffset = 0;
            ++this.byteOffset;
        }
    }

    public boolean isByteAligned() {
        return this.bitOffset == 0;
    }

    public DVBString readDVBString() {
        DVBString result = null;
        this.skiptoByteBoundary();
        result = new DVBString(this.bytes, this.byteOffset);
        int noBytes = result.getLength() + 1;
        this.byteOffset += noBytes;
        return result;
    }

    public int available() {
        return 8 * (this.lastBytePlusOne - this.byteOffset) - this.bitOffset;
    }

    public int getNextFullByteOffset() {
        return this.bitOffset == 0 ? this.byteOffset : this.byteOffset + 1;
    }

    public int nextBits(int bits) {
        int numBits = bits;
        int localBitOffset = this.bitOffset;
        int localByteOffset = this.byteOffset;
        if (numBits < 1 || numBits > 32) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        if (localBitOffset > 0) {
            int bitsLeft = 8 - localBitOffset;
            int toRead = Math.min(numBits, bitsLeft);
            int bitsToNotRead = bitsLeft - toRead;
            int mask = 255 >> 8 - toRead << bitsToNotRead;
            result = (this.bytes[localByteOffset] & mask) >> bitsToNotRead;
            numBits -= toRead;
            if ((localBitOffset += toRead) == 8) {
                localBitOffset = 0;
                ++localByteOffset;
            }
        }
        if (numBits > 0) {
            while (numBits >= 8) {
                result = result << 8 | this.bytes[localByteOffset] & 0xFF;
                ++localByteOffset;
                numBits -= 8;
            }
            if (numBits > 0) {
                int bitsToNotRead = 8 - numBits;
                int mask = 255 >> bitsToNotRead << bitsToNotRead;
                result = result << numBits | (this.bytes[localByteOffset] & mask) >> bitsToNotRead;
                localBitOffset += numBits;
            }
        }
        return result;
    }

    public int readSignedInt(int numBits) {
        if (numBits < 2) {
            throw new IllegalArgumentException("signed int should be at least 2 bits");
        }
        if (numBits > 31) {
            throw new IllegalArgumentException("signed int can have at most 31 bits");
        }
        int i = this.readBits(numBits);
        if (i >= powerOf2[numBits - 1]) {
            i -= powerOf2[numBits];
        }
        return i;
    }

    public byte readSignedByte(int numBits) {
        if (numBits < 2) {
            throw new IllegalArgumentException("signed byte should be at least 2 bits");
        }
        if (numBits > 8) {
            throw new IllegalArgumentException("signed byte can have at most 8 bits");
        }
        int i = this.readSignedInt(numBits);
        return (byte)i;
    }

    public int u(int v) {
        return this.readBits(v);
    }

    public int i(int v) {
        return this.readSignedInt(v);
    }

    public int f(int v) {
        return this.readBits(v);
    }

    private int getCodeNum() {
        int leadingZeroBits = -1;
        int b = 0;
        while (b == 0) {
            b = this.readBits(1);
            ++leadingZeroBits;
        }
        return powerOf2[leadingZeroBits] - 1 + this.readBits(leadingZeroBits);
    }

    public int ue() {
        return this.getCodeNum();
    }

    public int se() {
        int codeNum = this.getCodeNum();
        int absVal = (codeNum + 1) / 2;
        int sign = codeNum % 2 == 0 ? -1 : 1;
        return absVal * sign;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("BitSource: ");
        if (this.bytes != null) {
            b.append("bytes.length=").append(this.bytes.length);
        } else {
            b.append("bytes == null");
        }
        b.append(", byteOffset=").append(this.byteOffset);
        b.append(", bitOffset=").append(this.bitOffset);
        return b.toString();
    }

    @Override
    public String getHTML() {
        StringBuilder b = new StringBuilder();
        int localByteOffset = this.byteOffset;
        if (this.bitOffset != 0) {
            int bitsLeft = 8 - this.bitOffset;
            int intValueWholeByte = Byte.toUnsignedInt(this.bytes[localByteOffset]);
            String binaryString = Integer.toBinaryString(intValueWholeByte);
            String binaryStringPadded = ("0000000" + binaryString).substring(binaryString.length() - bitsLeft + 7);
            b.append(bitsLeft).append(" bits left of ").append(intValueWholeByte).append(" ( 0b").append(binaryStringPadded).append(")");
            b.append("<br><br>");
            ++localByteOffset;
        }
        if (this.bytes != null) {
            b.append(Utils.getHTMLHexview(this.bytes, localByteOffset, this.lastBytePlusOne - localByteOffset));
        } else {
            b.append("bytes == null");
        }
        return b.toString();
    }

    public int variable_bits(int n_bits) {
        int b_read_more;
        int value = 0;
        do {
            value += this.readBits(n_bits);
            b_read_more = this.readBits(1);
            if (b_read_more != 1) continue;
            value <<= n_bits;
            value += 1 << n_bits;
        } while (b_read_more == 1);
        return value;
    }
}

