/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class NtpTimeStamp
implements Serializable,
Comparable<NtpTimeStamp> {
    private static final long serialVersionUID = 8139806907588338737L;
    protected static final long msb0baseTime = 2085978496000L;
    protected static final long msb1baseTime = -2208988800000L;
    public static final String NTP_DATE_FORMAT = "EEE, MMM dd yyyy HH:mm:ss.SSS";
    private final long ntpTime;
    private DateFormat simpleFormatter;
    private DateFormat utcFormatter;

    public NtpTimeStamp(long ntpTime) {
        this.ntpTime = ntpTime;
    }

    public NtpTimeStamp(String hexStamp) throws NumberFormatException {
        this.ntpTime = NtpTimeStamp.decodeNtpHexString(hexStamp);
    }

    public NtpTimeStamp(Date d) {
        this.ntpTime = d == null ? 0L : NtpTimeStamp.toNtpTime(d.getTime());
    }

    public long ntpValue() {
        return this.ntpTime;
    }

    public long getSeconds() {
        return this.ntpTime >>> 32 & 0xFFFFFFFFL;
    }

    public long getFraction() {
        return this.ntpTime & 0xFFFFFFFFL;
    }

    public long getTime() {
        return NtpTimeStamp.getTime(this.ntpTime);
    }

    public Date getDate() {
        long time = NtpTimeStamp.getTime(this.ntpTime);
        return new Date(time);
    }

    public static long getTime(long ntpTimeValue) {
        long seconds = ntpTimeValue >>> 32 & 0xFFFFFFFFL;
        long fraction = ntpTimeValue & 0xFFFFFFFFL;
        fraction = Math.round(1000.0 * (double)fraction / 4.294967296E9);
        long msb = seconds & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + seconds * 1000L + fraction;
        }
        return -2208988800000L + seconds * 1000L + fraction;
    }

    public static NtpTimeStamp getNtpTime(long date) {
        return new NtpTimeStamp(NtpTimeStamp.toNtpTime(date));
    }

    public static NtpTimeStamp getCurrentTime() {
        return NtpTimeStamp.getNtpTime(System.currentTimeMillis());
    }

    protected static long decodeNtpHexString(String hexString) throws NumberFormatException {
        if (hexString == null) {
            throw new NumberFormatException("null");
        }
        int ind = hexString.indexOf(46);
        if (ind == -1) {
            if (hexString.length() == 0) {
                return 0L;
            }
            return Long.parseLong(hexString, 16) << 32;
        }
        return Long.parseLong(hexString.substring(0, ind), 16) << 32 | Long.parseLong(hexString.substring(ind + 1), 16);
    }

    public static NtpTimeStamp parseNtpString(String s) throws NumberFormatException {
        return new NtpTimeStamp(NtpTimeStamp.decodeNtpHexString(s));
    }

    protected static long toNtpTime(long t) {
        boolean useBase1 = t < 2085978496000L;
        long baseTime = useBase1 ? t - -2208988800000L : t - 2085978496000L;
        long seconds = baseTime / 1000L;
        long fraction = baseTime % 1000L * 0x100000000L / 1000L;
        if (useBase1) {
            seconds |= 0x80000000L;
        }
        long time = seconds << 32 | fraction;
        return time;
    }

    public int hashCode() {
        return (int)(this.ntpTime ^ this.ntpTime >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NtpTimeStamp) {
            return this.ntpTime == ((NtpTimeStamp)obj).ntpValue();
        }
        return false;
    }

    public String toString() {
        return NtpTimeStamp.toString(this.ntpTime);
    }

    private static void appendHexString(StringBuilder buf, long l) {
        String s = Long.toHexString(l);
        buf.append("0".repeat(Math.max(0, 8 - s.length())));
        buf.append(s);
    }

    public static String toString(long ntpTime) {
        StringBuilder buf = new StringBuilder();
        NtpTimeStamp.appendHexString(buf, ntpTime >>> 32 & 0xFFFFFFFFL);
        buf.append('.');
        NtpTimeStamp.appendHexString(buf, ntpTime & 0xFFFFFFFFL);
        return buf.toString();
    }

    public String toDateString() {
        if (this.simpleFormatter == null) {
            this.simpleFormatter = new SimpleDateFormat(NTP_DATE_FORMAT, Locale.US);
            this.simpleFormatter.setTimeZone(TimeZone.getDefault());
        }
        Date ntpDate = this.getDate();
        return this.simpleFormatter.format(ntpDate);
    }

    public String toUTCString() {
        if (this.utcFormatter == null) {
            this.utcFormatter = new SimpleDateFormat("EEE, MMM dd yyyy HH:mm:ss.SSS 'UTC'", Locale.US);
            this.utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Date ntpDate = this.getDate();
        return this.utcFormatter.format(ntpDate);
    }

    @Override
    public int compareTo(NtpTimeStamp anotherTimeStamp) {
        long thisVal = this.ntpTime;
        long anotherVal = anotherTimeStamp.ntpTime;
        return Long.compare(thisVal, anotherVal);
    }
}

