/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.Arrays;
import javax.swing.tree.MutableTreeNode;
import nl.digitalekabeltelevisie.data.mpeg.PID;
import nl.digitalekabeltelevisie.data.mpeg.TransportStream;
import nl.digitalekabeltelevisie.util.LazyListItemGetter;

public class PIDPacketGetter
implements LazyListItemGetter {
    TransportStream transportStream = null;
    int modus;
    int pid;
    int[] packetMapping = null;

    public PIDPacketGetter(TransportStream ts, int pid, int modus) {
        this.transportStream = ts;
        this.pid = pid;
        this.modus = modus;
    }

    @Override
    public MutableTreeNode getTreeNode(int i) {
        if (this.packetMapping == null) {
            this.buildPacketMapping();
        }
        return this.transportStream.getTSPacket(this.packetMapping[i]).getJTreeNode(this.modus);
    }

    private void buildPacketMapping() {
        int k = 0;
        this.packetMapping = new int[this.getNoItems()];
        for (int j = 0; j < this.transportStream.getNo_packets(); ++j) {
            short p = this.transportStream.getPacket_pid(j);
            if (p != this.pid) continue;
            this.packetMapping[k++] = j;
        }
    }

    @Override
    public int getNoItems() {
        PID p = this.transportStream.getPID(this.pid);
        if (p != null) {
            return p.getPackets();
        }
        return 0;
    }

    @Override
    public int getActualNumberForIndex(int i) {
        if (this.packetMapping == null) {
            this.buildPacketMapping();
        }
        return this.packetMapping[i];
    }

    @Override
    public int getIndexForActualNumber(int a) {
        return Arrays.binarySearch(this.packetMapping, a);
    }
}

