/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.TreeMap;

public class RangeHashMap<K extends Comparable<?>, V> {
    private final TreeMap<K, Entry> table = new TreeMap();

    public void put(K start, K end, V value) {
        Entry e = new Entry(this, start, end, value);
        this.put(start, e);
    }

    public V find(K k) {
        Entry e = this.findEntry(k);
        if (e != null && e.getUpper().compareTo(k) >= 0) {
            return e.getValue();
        }
        return null;
    }

    public Entry findEntry(K k) {
        Entry e = null;
        Comparable lowkey = (Comparable)this.table.floorKey(k);
        if (lowkey != null) {
            e = this.table.get(lowkey);
        }
        return e;
    }

    public void put(K start, Entry entry) {
        this.table.put(start, entry);
    }

    public class Entry {
        private K lower;
        private K upper;
        private V value;

        /*
         * WARNING - Possible parameter corruption
         */
        public Entry(K lower, K upper, V value) {
            this.lower = lower;
            this.upper = upper;
            this.value = value;
        }

        public K getUpper() {
            return this.upper;
        }

        public V getValue() {
            return this.value;
        }

        public K getLower() {
            return this.lower;
        }

        public void setLower(K lower) {
            this.lower = lower;
        }

        public void setUpper(K upper) {
            this.upper = upper;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public String toString() {
            return "Entry [lower=" + String.valueOf(this.lower) + ", upper=" + String.valueOf(this.upper) + ", value=" + String.valueOf(this.value) + "]";
        }
    }
}

