/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util;

import java.util.Objects;
import nl.digitalekabeltelevisie.util.RangeHashMap;

public class RollOverHelper {
    private RangeHashMap<Integer, Long> rangeHashMap = new RangeHashMap();
    private int maxPackets = -1;
    RangeHashMap.Entry currentEntry = null;

    public RollOverHelper(int max_packets) {
        this.maxPackets = max_packets;
    }

    public void addPacket(int packetNo, long rollOver) {
        if (this.currentEntry == null) {
            RangeHashMap<Integer, Long> rangeHashMap = this.rangeHashMap;
            Objects.requireNonNull(rangeHashMap);
            this.currentEntry = new RangeHashMap.Entry(rangeHashMap, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.maxPackets), (Object)rollOver);
            this.rangeHashMap.put(0, this.currentEntry);
        } else if ((Long)this.currentEntry.getValue() != rollOver) {
            this.currentEntry.setUpper(packetNo - 1);
            RangeHashMap<Integer, Long> rangeHashMap = this.rangeHashMap;
            Objects.requireNonNull(rangeHashMap);
            this.currentEntry = new RangeHashMap.Entry(rangeHashMap, (Comparable)Integer.valueOf(packetNo), (Comparable)Integer.valueOf(this.maxPackets), (Object)rollOver);
            this.rangeHashMap.put(packetNo, this.currentEntry);
        }
    }

    public int getMaxPacket() {
        return this.maxPackets;
    }

    public long getRollOver(int packetNo) {
        RangeHashMap.Entry entry = this.rangeHashMap.findEntry(packetNo);
        return (Long)entry.getValue();
    }
}

