/*
 * Decompiled with CFR 0.152.
 */
package nl.digitalekabeltelevisie.util.tablemodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import nl.digitalekabeltelevisie.util.tablemodel.ColumnDetails;
import nl.digitalekabeltelevisie.util.tablemodel.TableHeader;

public class FlexTableModel<E, R>
extends AbstractTableModel {
    private static final String REPEATING_KEY_SEPARATOR = ":";
    private final List<Map<String, Object>> model = new ArrayList<Map<String, Object>>();
    private final TableHeader<E, R> tableHeader;
    private final List<String> displayableColumns = new ArrayList<String>();

    public FlexTableModel(TableHeader<E, R> tableHeader) {
        this.tableHeader = tableHeader;
    }

    public void addData(E entity, List<? extends R> rows) {
        for (R row : rows) {
            if (row == null) continue;
            HashMap<Object, Object> rowData = new HashMap<Object, Object>();
            List<ColumnDetails<?>> columns = this.tableHeader.header();
            for (ColumnDetails<?> column : columns) {
                Object r;
                Function<?, Object> fun;
                int t;
                List<Object> listValues;
                Function<?, List<Object>> listFun;
                if (column.isBaseColumn()) {
                    if (column.isList()) {
                        listFun = column.getListFunction();
                        listValues = listFun.apply(entity);
                        if (listValues == null) continue;
                        t = 0;
                        for (Object val : listValues) {
                            rowData.put(column.getKey() + REPEATING_KEY_SEPARATOR + t, val);
                            ++t;
                        }
                        continue;
                    }
                    fun = column.getFunction();
                    r = fun.apply(entity);
                    rowData.put(column.getKey(), r);
                    continue;
                }
                if (!column.isList()) {
                    fun = column.getFunction();
                    r = fun.apply(row);
                    rowData.put(column.getKey(), r);
                    continue;
                }
                listFun = column.getListFunction();
                listValues = listFun.apply(row);
                if (listValues == null) continue;
                t = 0;
                for (Object val : listValues) {
                    rowData.put(column.getKey() + REPEATING_KEY_SEPARATOR + t, val);
                    ++t;
                }
            }
            this.model.add(rowData);
        }
    }

    public void process() {
        this.determineUsedColumns();
        this.buildDisplayableColumnsList();
    }

    private void buildDisplayableColumnsList() {
        List<ColumnDetails<?>> header = this.tableHeader.header();
        for (int headerIndex = 0; headerIndex < header.size(); ++headerIndex) {
            ColumnDetails<?> column = header.get(headerIndex);
            if (!column.isUsed() && !column.isRequired()) continue;
            if (column.isList()) {
                if (column.getGroupId() == null) {
                    this.addRepeatingColumn(column);
                    continue;
                }
                headerIndex = this.addRepeatingColumnGroup(header, headerIndex, column);
                continue;
            }
            this.addSimpleColumn(column);
        }
    }

    private int addRepeatingColumnGroup(List<? extends ColumnDetails<?>> header, int headerIndexStart, ColumnDetails<?> column) {
        int headerIndex = headerIndexStart;
        ArrayList groupList = new ArrayList();
        int iterCount = column.getListMax();
        groupList.add(column);
        while (headerIndex + 1 < header.size() && header.get(headerIndex + 1).isList() && column.getGroupId().equals(header.get(headerIndex + 1).getGroupId())) {
            ColumnDetails<?> nextCol = header.get(headerIndex + 1);
            iterCount = Integer.max(iterCount, nextCol.getListMax());
            groupList.add(nextCol);
            ++headerIndex;
        }
        for (int i = 0; i <= iterCount; ++i) {
            for (ColumnDetails columnDetails : groupList) {
                String baseKey = columnDetails.getKey();
                this.displayableColumns.add(baseKey + REPEATING_KEY_SEPARATOR + i);
            }
        }
        return headerIndex;
    }

    private void addSimpleColumn(ColumnDetails<?> column) {
        this.displayableColumns.add(column.getKey());
    }

    private void addRepeatingColumn(ColumnDetails<?> column) {
        String baseKey = column.getKey();
        for (int i = 0; i <= column.getListMax(); ++i) {
            this.displayableColumns.add(baseKey + REPEATING_KEY_SEPARATOR + i);
        }
    }

    private void determineUsedColumns() {
        for (Map<String, Object> row : this.model) {
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                String key = entry.getKey();
                if (FlexTableModel.isRepeatingKey(key)) {
                    String keyBase = FlexTableModel.getBase(key);
                    int keyOrd = FlexTableModel.getOrdinal(key);
                    if (!this.tableHeader.isRepeatingColumn(keyBase)) continue;
                    this.tableHeader.countOrdinal(keyBase, keyOrd);
                    continue;
                }
                if (entry.getValue() == null) continue;
                this.tableHeader.flagUsed(key);
            }
        }
    }

    private static int getOrdinal(String key) {
        int i = key.indexOf(REPEATING_KEY_SEPARATOR);
        return Integer.parseInt(key.substring(i + 1));
    }

    private static String getBase(String key) {
        int i = key.indexOf(REPEATING_KEY_SEPARATOR);
        if (i == -1) {
            return key;
        }
        return key.substring(0, i);
    }

    private static boolean isRepeatingKey(String key) {
        return key.contains(REPEATING_KEY_SEPARATOR);
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return this.displayableColumns.size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        ColumnDetails<?> columnDetails = this.tableHeader.map().get(this.getBaseKey(columnIndex));
        return columnDetails.getDataClass();
    }

    private String getBaseKey(int columnIndex) {
        return FlexTableModel.getBase(this.displayableColumns.get(columnIndex));
    }

    @Override
    public String getColumnName(int column) {
        String key = this.displayableColumns.get(column);
        ColumnDetails<?> columnDetails = this.tableHeader.map().get(FlexTableModel.getBase(key));
        if (columnDetails.isList()) {
            String baseName = columnDetails.getName();
            return baseName + " " + FlexTableModel.getOrdinal(key);
        }
        return columnDetails.getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.get(rowIndex).get(this.displayableColumns.get(columnIndex));
    }
}

