/**
 *
 *  http://www.digitalekabeltelevisie.nl/dvb_inspector
 *
 *  This code is Copyright 2009-2014 by Eric Berendsen (e_berendsen@digitalekabeltelevisie.nl)
 *
 *  This file is part of DVB Inspector.
 *
 *  DVB Inspector is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DVB Inspector is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DVB Inspector.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  The author requests that he be notified of any application, applet, or
 *  other binary that makes use of this code, but that's more out of curiosity
 *  than anything and is not required.
 *
 */

package nl.digitalekabeltelevisie.data.mpeg.descriptors.extension.dvb;

import static nl.digitalekabeltelevisie.util.Utils.*;

import javax.swing.tree.DefaultMutableTreeNode;

import nl.digitalekabeltelevisie.controller.KVP;
import nl.digitalekabeltelevisie.data.mpeg.psi.TableSection;

public class MessageDescriptor extends DVBExtensionDescriptor {


	//Supplementary audio descriptor
	private final int message_id;
	private final String iso639LanguageCode;
	private final String message;



	public MessageDescriptor(final byte[] b, final int offset, final TableSection parent) {
		super(b, offset,parent);
		message_id = getInt(b, offset+3, 1, MASK_8BITS);
		iso639LanguageCode = getISO8859_1String(b, offset+4, 3);
		message = getString(b, offset+7, descriptorLength -5);
	}


	@Override
	public DefaultMutableTreeNode getJTreeNode(final int modus){

		final DefaultMutableTreeNode t = super.getJTreeNode(modus);
		t.add(new DefaultMutableTreeNode(new KVP("message_id",message_id,null)));
		t.add(new DefaultMutableTreeNode(new KVP("iso639LanguageCode",iso639LanguageCode,null)));
		t.add(new DefaultMutableTreeNode(new KVP("message",message,null)));

		return t;
	}

}
