/**
 *
 *  http://www.digitalekabeltelevisie.nl/dvb_inspector
 *
 *  This code is Copyright 2009-2022 by Eric Berendsen (e_berendsen@digitalekabeltelevisie.nl)
 *
 *  This file is part of DVB Inspector.
 *
 *  DVB Inspector is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  DVB Inspector is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with DVB Inspector.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  The author requests that he be notified of any application, applet, or
 *  other binary that makes use of this code, but that's more out of curiosity
 *  than anything and is not required.
 *
 */

package nl.digitalekabeltelevisie.util;

import javax.swing.tree.MutableTreeNode;


/**
 * Interface to be implemented by helpers for JTreeLazyList.
 *
 * @author Eric
 *
 * @see JTreeLazyList
 *
 */
public interface LazyListItemGetter {

	/**
	 * Returns the i-the element
	 * @param i
	 * @return
	 */
	MutableTreeNode getTreeNode(int i);

	/**
	 * @return total number of elements to be displayed
	 */
	int getNoItems();
	
	/**
	 * Return the number of the packet for the i-th packet in this list
	 * For list off all packets the return value will be equal to i, for list of Packets 
	 * in PID the return value will be the position  (in the stream) of the i-th packet in this PID
	 * 
	 * @param i
	 * @return
	 */
	default int getActualNumberForIndex(int i) {
		return i;
	}

	default int getIndexForActualNumber(int i) {
		return i;
	}


}
